//
//  SFNTWriterData.h
//  GSFontTools
//
//  Created by Georg Seifert on 11.12.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "SFNTWriter.h"

@interface SFNTWriterData : NSObject <SFNTWriter> {
	NSMutableData *_data;
	NSUInteger _numTables;
	char _sfntVersion[4];
	int _searchRange;
	int _entrySelector;
	int _rangeShift;
	int _nextTableOffset;
	NSMutableDictionary * _tables;
}

@property (readonly, nonatomic) NSData *data;

- (id) initWithTabelCount:(int)numTables ;
- (void) setData:(NSData*)Data forKey:(id) Tag;
//- (void) calcMasterChecksum:(NSData *)directory;
- (void) setSfntVersion:(char *)SfntVersion;
- (void) close;
@end
